// Apply Filter Editor
// this class is used to display the options to the user after clicking on a saved filter
// the options would be to Clear all existing filters and apply the new, or apply the content of the filter
// instead of a reference to it.

function ApplyFilterEditor(eid)
{
   this.frame = document.getElementById(eid + 'Frame');

   this.form = document.forms[eid + 'Form'];
   this.locationDiv = document.getElementById(eid + 'Location');
   this.htmlTable = document.getElementById(eid + 'Table');
}

ApplyFilterEditor.prototype = new XUIEditor();

// LoadSavedFilter
// param: sPath, the path of the saved filter

ApplyFilterEditor.prototype.loadSavedFilter = function(sPath)
{
   this.frame.src = saw.commandToURL("LoadSavedFilter") + "&FilterPath=" + saw.encodeURIComponent(sPath);

   return true;
}

ApplyFilterEditor.prototype.load = function(xmlElement)
{
   this.filter = xmlElement.selectSingleNode("//saw:filter");
   this.element = saw.getFirstChildElement(this.filter);

   // column space
   this.filterColumnSpace = xmlElement.selectSingleNode("//saw:columnSpace");

   this.displayApplyFilter();

   return true;
}

ApplyFilterEditor.prototype.apply = function()
{
   this.filterEditor = XUIPanel.getEditor('idFilter');

   if(this.form.clear.checked)
      this.filterEditor.deleteAllFilters();

   if(this.form.content.checked)
   {
      this.filterEditor.newExpr = this.element;

      // append the column space entries if not present already
      if (null != this.filterColumnSpace)
      {
         // column space should have been initialized already
         var tColumnSpace = XUIColumnSpace.getColumnSpaceElement();
         if (null != tColumnSpace)
         {
            var tColumnInfos = this.filterColumnSpace.selectNodes(".//saw:columnInfo");
            var tColumnInfo;
            for (var i=0; i < tColumnInfos.length; i++)
            {
               tColumnInfo = tColumnInfos[i];
               var tCurrent = XUIColumnSpace.findInfo(null, tColumnInfo.getAttribute("formula"));
               if (null == tCurrent)
                  tColumnSpace.appendChild (tColumnInfo.cloneNode(true));
            }
         }
      }
   }
   else
   {
      var tExpr = XUICreateElement(saw.xml.kSawxNamespace, 'expr');
      XUISetXsiType(tExpr,saw.xml.kSawNamespace,'savedFilter');
      XUISetAttributeString(tExpr,"path",this.path);
      XUISetAttributeString(tExpr,"name",this.filterName);
      this.filterEditor.newExpr = tExpr;
      this.element = tExpr;
   }

   return true;
}

ApplyFilterEditor.prototype.displayApplyFilter = function()
{
   this.locationDiv.innerHTML = this.location;

   this.displayFilter();
}

ApplyFilterEditor.prototype.clearHTMLTable = function()
{
   while (this.htmlTable.rows.length > 0)
      this.htmlTable.deleteRow(0);
}

ApplyFilterEditor.prototype.displayFilter = function()
{
   this.clearHTMLTable();

   if(this.filter.hasChildNodes())
   {
      var tr = this.htmlTable.insertRow(this.htmlTable.rows.length);
      FilterEditor.addCellsForExpr(this.element, tr, false);
   }
}

ApplyFilterEditor.displayOptions = function(eid)
{
   var tEditor = XUIPanel.getEditor(eid);
   var tFilterEditor = XUIPanel.getEditor('idFilter');

   var tFrame = window.frames[eid + "Frame"];

   var tForm = tFrame.document.forms[eid + 'Form'];

   tEditor.location   = tForm.Location.value;
   tEditor.path       = tForm.Path.value;
   tEditor.filterName = tForm.FilterName.value;

   // get the xml of the filter from the hidden frame.
   var tRootXML = saw.getXmlIsland("idXUI", tFrame, tFrame);

   // add the filter caption to the caption catalog space
   var tCatalogCaptionSpace = tRootXML.selectSingleNode('//saw:catalogCaptionSpace');
   XUICatalogCaptionSpace.add(tCatalogCaptionSpace);

   var tDialog = new XUIDialog('idFilterApply',tEditor,tFilterEditor);

   tDialog.show(tRootXML,70,50, null, null, true, true);

   return true;
}
